<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Project extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'acronym',
        'cup_code',
        'codice_coge',
        'announcement',
        'funding_body_id',
        'principal_investigator',
        'start_date',
        'end_date',
        'total_months',
        'iul_role',
        'total_project_value',
        'iul_grant',
        'iul_cofinancing',
    ];

    protected $casts = [
        'start_date' => 'date',
        'end_date' => 'date',
        'total_project_value' => 'decimal:2',
        'iul_cofinancing' => 'decimal:2',
    ];

    public function fundingBodies(): BelongsToMany
    {
        return $this->belongsToMany(FundingBody::class);
    }

    public function people(): BelongsToMany
    {
        return $this->belongsToMany(Anagrafica::class, 'anagrafiche_project')->withTimestamps()->withPivot('work_package_id', 'budget_item_id', 'is_esterno');
    }

    public function budgetItems(): HasMany
    {
        return $this->hasMany(BudgetItem::class);
    }

    public function payments(): HasMany
    {
        return $this->hasMany(ProjectPayment::class);
    }

    public function documents(): HasMany
    {
        return $this->hasMany(ProjectDocument::class);
    }

    public function workPackages(): HasMany
    {
        return $this->hasMany(WorkPackage::class);
    }

}
