<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class FiguraProfessionalePropostaCorso extends Model
{
    use HasFactory;

    protected $fillable = [
        'proposta_corso_id',
        'modulo_proposta_corso_id',
        'ruolo',
        'cognome',
        'nome'
    ];

    protected $appends = ['nome_completo'];

    public function getNomeCompletoAttribute(): string
    {
        return "{$this->cognome} {$this->nome}";
    }

    public function propostaCorso(): BelongsTo
    {
        return $this->belongsTo(PropostaCorso::class);
    }

    public function modulo(): BelongsTo
    {
        return $this->belongsTo(ModuloPropostaCorso::class, 'modulo_proposta_corso_id');
    }
}
