<?php

namespace App\Mail;

use App\Models\PropostaCorso;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Mail\Mailables\Attachment;

class PropostaCorsoInviata extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(
        public PropostaCorso $propostaCorso,
        public string $pdfPath
    ) {}

    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Nuova proposta corso: ' . $this->propostaCorso->titolo,
        );
    }

    public function content(): Content
    {
        return new Content(
            markdown: 'emails.proposta-corso-inviata',
        );
    }

    public function attachments(): array
    {
        return [
            Attachment::fromPath($this->pdfPath)
                ->as('proposta-corso.pdf')
                ->withMime('application/pdf'),
        ];
    }
} 