<?php

namespace App\Livewire;

use App\Models\SupabaseUser;
use Livewire\Component;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Tables\Contracts\HasTable;
use Filament\Tables\Table;
use Filament\Tables\Actions\Action;

class SupabaseUsersTable extends Component implements HasForms, HasTable
{
    use InteractsWithTable;
    use InteractsWithForms;

    public function table(Table $table): Table
    {
        return $table
            ->query(SupabaseUser::query())
            ->columns([
                TextColumn::make('user_email')
                    ->label('Email utente')
                    ->searchable()
                    ->sortable(),
                TextColumn::make('last_message_at')
                    ->label('Ultimo messaggio')
                    ->dateTime()
                    ->sortable(),
                TextColumn::make('message_count')
                    ->label('Numero messaggi')
                    ->sortable(),
            ])
            ->actions([
                Action::make('view_messages')
                    ->label('Visualizza messaggi')
                    ->icon('heroicon-o-chat-bubble-left-right')
                    ->color('primary')
                    ->action(function ($record) {
                        $this->dispatch('select-email', email: $record->user_email);
                    })
            ])
            ->defaultSort('last_message_at', 'desc')
            ->striped()
            ->searchable()
            ->paginated([10, 25, 50, 100]);
    }

    public function render()
    {
        return view('livewire.supabase-users-table');
    }
}
