<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class FirstAccessPasswordReset
{
    public function handle(Request $request, Closure $next): Response
    {
        if (!Auth::check()) {
            return $next($request);
        }

        $user = Auth::user();

        // Se è il primo accesso e l'utente ha il ruolo "utente", redirect al reset password
        if ($user->hasRole('utente') && 
            $user->first_access && 
            !$request->is('admin/reset-password') && 
            !$request->is('admin/logout')) {
            return redirect()->route('filament.admin.pages.reset-password');
        }

        // Se l'utente ha il ruolo "utente" e sta cercando di accedere alla root di admin
        if ($user->hasRole('utente') && $request->is('admin')) {
            return redirect('/admin/user-dashboard');
        }

        return $next($request);
    }
} 
