<?php

namespace App\Helpers;

use Illuminate\Support\Facades\Blade;
use Illuminate\Support\Str;

class ContextualHelp
{
    protected static array $helpConfig = [
        'anagrafica' => [
            'file' => 'docs/it/anagrafiche/anagrafica.md',
            'title' => 'Documentazione Anagrafica',
            'icon' => 'heroicon-o-question-mark-circle',
            'paths' => ['anagrafica', 'anagrafiche'],
        ],
        'contratti' => [
            'file' => 'docs/it/contratti/contratti.md',
            'title' => 'Documentazione Contratti',
            'icon' => 'heroicon-o-document-text',
            'paths' => ['contratti', 'contratto'],
        ],
    ];

    public static function render(): string
    {
        $currentPath = request()->path();
        
        foreach (static::$helpConfig as $context => $config) {
            if (static::isCurrentPath($currentPath, $config['paths'])) {
                return static::renderHelp($context, $config);
            }
        }
        
        return '';
    }

    protected static function isCurrentPath(string $currentPath, array $paths): bool
    {
        foreach ($paths as $path) {
            if (str_contains($currentPath, $path)) {
                return true;
            }
        }
        return false;
    }

    protected static function renderHelp(string $context, array $config): string
    {
        if (!file_exists(base_path($config['file']))) {
            return '';
        }

        return Blade::render(<<<BLADE
            <x-filament::modal
                id="documentation-viewer-{$context}"
                slide-over
                width="4xl"
            >
                <x-slot name="trigger">
                    <x-filament::button
                        icon="{$config['icon']}"
                        icon-alias="panels::user-menu.documentation-viewer"
                        labeled-from="sm"
                        color="gray"
                        size="sm"
                    >
                        Help
                    </x-filament::button>
                </x-slot>

                <x-slot name="heading">
                    {$config['title']}
                </x-slot>

                <div class="prose dark:prose-invert max-w-none">
                    {!! Str::markdown(file_get_contents(base_path('{$config['file']}'))) !!}
                </div>
            </x-filament::modal>
        BLADE);
    }
} 