<?php

namespace App\Filament\Widgets;

use App\Models\Contratto;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget as BaseWidget;

class ContrattiRecenti extends BaseWidget
{
    protected static ?string $heading = 'Ultimi Contratti Firmati';
    protected static ?int $sort = 3;
    protected int|string|array $columnSpan = 'full';

    public function table(Table $table): Table
    {
        return $table
            ->query(
                Contratto::query()
                    ->with(['tipoContratto', 'secondoFirmatario'])
                    ->where('yousign_status', 'completed')
                    ->latest()
                    ->limit(5)
            )
            ->heading('Ultimi Contratti Firmati')
            ->columns([
                Tables\Columns\TextColumn::make('tipoContratto.nome')
                    ->label('Tipo Contratto')
                    ->searchable(),
                Tables\Columns\TextColumn::make('secondoFirmatario.nome')
                    ->label('Firmatario')
                    ->formatStateUsing(fn ($record) => $record->secondoFirmatario ? "{$record->secondoFirmatario->nome} {$record->secondoFirmatario->cognome}" : 'N/D')
                    ->searchable(),
                Tables\Columns\TextColumn::make('yousign_status')
                    ->label('Stato Firma')
                    ->badge()
                    ->formatStateUsing(fn (string $state): string => match ($state) {
                        'pending' => 'In attesa',
                        'completed' => 'Firmato',
                        'rejected' => 'Rifiutato',
                        'expired' => 'Scaduto',
                        'error' => 'Errore',
                        default => ucfirst($state),
                    })
                    ->color(fn (string $state): string => match ($state) {
                        'pending' => 'warning',
                        'completed' => 'success',
                        'rejected' => 'danger',
                        'expired' => 'danger',
                        'error' => 'danger',
                        default => 'primary',
                    }),
                Tables\Columns\TextColumn::make('created_at')
                    ->label('Data')
                    ->dateTime()
                    ->sortable(),
            ])
            ->paginated(false);
    }
}
