<?php

namespace App\Filament\Widgets;

use App\Models\Anagrafica;
use Filament\Widgets\ChartWidget;
use Flowframe\Trend\Trend;
use Flowframe\Trend\TrendValue;

class AnagraficaRegistrationChart extends ChartWidget
{
    protected static ?string $heading = 'Registrazioni Anagrafiche';

    protected function getData(): array
    {
        $data = Trend::model(Anagrafica::class)
            ->between(
                start: now()->startOfYear(),
                end: now()->endOfYear(),
            )
            ->perMonth()
            ->count();

        return [
            'datasets' => [
                [
                    'label' => 'Registrazioni',
                    'data' => $data->map(fn (TrendValue $value) => $value->aggregate),
                    'backgroundColor' => '#36A2EB',
                ],
            ],
            'labels' => $data->map(fn (TrendValue $value) => $value->date),
        ];
    }

    protected function getType(): string
    {
        return 'bar';
    }
}
