<?php

namespace App\Filament\Resources\ProjectResource\RelationManagers;

use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Models\WorkPackage;
use App\Models\BudgetItem;

class PeopleRelationManager extends RelationManager
{
    protected static string $relationship = 'people';

    public function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('nome'),
                Tables\Columns\TextColumn::make('cognome'),
                Tables\Columns\TextColumn::make('work_package_id')
                    ->label('Work Package')
                    ->formatStateUsing(fn (String $state) => WorkPackage::where('id', $state)->pluck('title')->first()),
            ])//TODO FILTRI
            ->filters([
                //
            ])
            ->headerActions([])
            ->actions([
                Tables\Actions\DetachAction::make()
                    ->before(fn ($record) => BudgetItem::where('id', $record->budget_item_id)->delete()),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make()
                        ->before(function ($records) {
                            foreach ($records as $record) {
                                BudgetItem::where('id', $record->budget_item_id)->delete();
                            }
                        }),
                ]),
            ]);
    }
}
