<?php

namespace App\Filament\Resources;

use App\Filament\Resources\FundingBodyResource\Pages;
use App\Filament\Resources\FundingBodyResource\RelationManagers;
use App\Models\FundingBody;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class FundingBodyResource extends Resource
{
    protected static ?string $model = FundingBody::class;

    protected static ?string $navigationIcon = 'heroicon-o-building-office';

    protected static ?string $navigationLabel = 'Enti Finanziatori';

    protected static ?string $modelLabel = 'Ente Finanziatore';

    protected static ?string $pluralModelLabel = 'Enti Finanziatori';

    protected static ?string $navigationGroup = 'Progetti';

    protected static ?int $navigationSort = 2;

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Section::make()
                    ->schema([
                        Forms\Components\TextInput::make('name')
                            ->label('Nome Ente')
                            ->required()
                            ->maxLength(255)
                            ->columnSpanFull(),

                        Forms\Components\Grid::make()
                            ->schema([
                                Forms\Components\TextInput::make('country')
                                    ->label('Paese')
                                    ->maxLength(255),

                                Forms\Components\Select::make('type')
                                    ->label('Tipologia')
                                    ->options([
                                        'eu' => 'Unione Europea',
                                        'national' => 'Nazionale',
                                        'private' => 'Privato',
                                        'university' => 'Università',
                                        'other' => 'Altro',
                                    ]),
                            ])
                            ->columns(2),

                        Forms\Components\Textarea::make('description')
                            ->label('Descrizione')
                            ->maxLength(65535)
                            ->columnSpanFull(),

                        Forms\Components\Toggle::make('is_active')
                            ->label('Attivo')
                            ->default(true)
                            ->columnSpanFull(),
                    ])
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('name')
                    ->label('Nome Ente')
                    ->searchable()
                    ->sortable(),
                Tables\Columns\TextColumn::make('country')
                    ->label('Paese')
                    ->searchable(),
                Tables\Columns\TextColumn::make('type')
                    ->label('Tipologia')
                    ->formatStateUsing(fn (string $state): string => match ($state) {
                        'eu' => 'Unione Europea',
                        'national' => 'Nazionale',
                        'private' => 'Privato',
                        'university' => 'Università',
                        'other' => 'Altro',
                        default => $state,
                    }),
                Tables\Columns\IconColumn::make('is_active')
                    ->label('Attivo')
                    ->boolean(),
                Tables\Columns\TextColumn::make('projects_count')
                    ->label('N. Progetti')
                    ->counts('projects')
                    ->sortable(),
            ])
            ->filters([
                Tables\Filters\SelectFilter::make('type')
                    ->label('Tipologia')
                    ->options([
                        'eu' => 'Unione Europea',
                        'national' => 'Nazionale',
                        'private' => 'Privato',
                        'university' => 'Università',
                        'other' => 'Altro',
                    ]),
                Tables\Filters\TernaryFilter::make('is_active')
                    ->label('Attivo')
                    ->default(true),
            ])
            ->actions([
                Tables\Actions\EditAction::make()
                    ->label('Modifica'),
                Tables\Actions\DeleteAction::make()
                    ->label('Elimina'),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListFundingBodies::route('/'),
            'create' => Pages\CreateFundingBody::route('/create'),
            'edit' => Pages\EditFundingBody::route('/{record}/edit'),
        ];
    }
}
