<?php

namespace App\Filament\Resources\ContrattoTemplateResource\Pages;

use App\Filament\Resources\ContrattoTemplateResource;
use Filament\Resources\Pages\ViewRecord;
use Filament\Actions\Action;
use Filament\Infolists\Components\Section;
use Filament\Infolists\Components\TextEntry;
use Filament\Infolists\Infolist;
use BezhanSalleh\FilamentShield\Contracts\HasShieldPermissions;
use App\Filament\Resources\ContrattoTemplateResource\RelationManagers\ContrattiRelationManager;

class ViewContrattoTemplate extends ViewRecord implements HasShieldPermissions
{
    protected static string $resource = ContrattoTemplateResource::class;

    public static function getPermissionPrefixes(): array
    {
        return [
            'viewAny',
            'view',
            'create',
            'update',
            'delete',
            'deleteAny'
        ];
    }

    public function infolist(Infolist $infolist): Infolist
    {
        return $infolist
            ->schema([
                Section::make()
                    ->schema([
                        TextEntry::make('nome'),
                        TextEntry::make('descrizione'),
                        TextEntry::make('contenuto')
                            ->html()
                            ->columnSpanFull(),
                    ])
                    ->columns(2)
            ]);
    }

    protected function getHeaderActions(): array
    {
        return [
            Action::make('back')
                ->label('Torna alla lista')
                ->url(static::getResource()::getUrl('index'))
                ->color('gray'),
        ];
    }

    protected function getRelations(): array
    {
        return [
            ContrattiRelationManager::class
        ];
    }
} 