<?php

namespace App\Filament\Pages;

use App\Filament\Widgets\AnagraficaStatsOverview;
use App\Filament\Widgets\AnagraficaRegistrationChart;
use App\Filament\Widgets\AnagraficaCompletionChart;
use App\Filament\Widgets\CalendarWidget;
use App\Filament\Widgets\ContractSignersWidget;
use App\Filament\Widgets\ContrattiRecenti;
use Filament\Pages\Dashboard as BaseDashboard;
use Illuminate\Support\Facades\Auth;

class Dashboard extends BaseDashboard
{
    protected static ?string $navigationIcon = 'heroicon-o-home';
    protected static ?string $navigationLabel = 'Dashboard';
    protected static ?int $navigationSort = -2;
    protected static ?string $title = 'Dashboard';
    
    protected static string $view = 'filament.pages.dashboard';

    public static function shouldRegisterNavigation(): bool
    {
        // Mostra la dashboard solo a super_admin e Staff IUL
        return !Auth::user()?->hasRole('utente');
    }
}
