# IUL - Connect

Gestionale interno sviluppato con Laravel 11 e Filament 3.
Nome in codice: IUL Connect.

## Requisiti

- PHP >= 8.2
- Composer
- MySQL/MariaDB
- Node.js e npm

## Installazione

1. Clonare il repository

```bash
git clone <repository-url>
cd <project-folder>
```

2. Configurare il file .env

```bash
cp .env.example .env
echo "BACKUP_NOTIFICATION_EMAIL=your@email.com" >> .env
php artisan key:generate
```

3. Configurare il database nel file .env

```bash
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=your_database
DB_USERNAME=your_username
DB_PASSWORD=your_password
```

OPZIONALE: Aggiungere un'api key di Google Maps nel file .env per avere l'autocomplete nell'anagrafica

```bash
GOOGLE_MAPS_API_KEY=xxxxx
```

4. Installare le dipendenze PHP

```bash
composer install
```

5. Installare le dipendenze JavaScript

```bash
npm install
npm run build
```

6. Eseguire le migrazioni del database con seed

```bash
php artisan migrate --seed
```

7. Lanciare il comando per aggiornare i file js e css mentre si lavora

```bash
npm run dev
```
